import {
    View,
    Text,
    ScrollView,
    TouchableOpacity,
    TouchableWithoutFeedback,
    StyleSheet,
} from 'react-native';
import React from 'react';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';
import AddressStyle from '../../Profile/Address/AddressStyle';
import EditIcon from '../../../assets/svgs/profile/edit profile.svg';
import { useNavigation } from '@react-navigation/native';
import useLangTranslation from '../../../hooks/useLangTranslation';
import useGuestUser from '../../../hooks/useGuestUser';
import gapStyle from '../../Utilities/CommonStyles/gap.style';
import CustomSVG from '../../../src/components/CustomSVG/CustomSVG';

const OrderAddresses = (props) => {
    const isGuest = useGuestUser();
    const { trans } = useLangTranslation();
    const { addresses, borderColor, handleSelectAddress } = props;
    const navigation = useNavigation();
    return (
        <ScrollView
            showsVerticalScrollIndicator={false}
            style={styles.container}
        >
            {addresses?.length > 0 && (
                <Text style={styles.selectAddressText}>
                    {trans('Select Your Address')}
                </Text>
            )}

            {addresses?.length > 0 &&
                addresses.map((address, index) => {
                    const {
                        address_1,
                        city,
                        country_name,
                        country,
                        first_name,
                        last_name,
                        is_default,
                        id,
                        phone,
                        zip,
                        type_of_place,
                    } = address;

                    return (
                        <TouchableWithoutFeedback
                            key={index}
                            onPress={() => isGuest ? "" : handleSelectAddress(address, id)}
                        >
                            <View
                                style={[
                                    AddressStyle.singleAddressCont,
                                    AddressStyle.defaultAddress2(borderColor, id)
                                ]}
                            >
                                <View style={AddressStyle.titleCont}>
                                    <Text style={AddressStyle.title}>
                                        {`${trans("Address")} ${index + 1} (${
                                            type_of_place
                                                .charAt(0)
                                                .toUpperCase() +
                                            type_of_place.slice(1)
                                        })`}
                                    </Text>
                                    {!isGuest && (
                                        <TouchableOpacity
                                            onPress={() =>
                                                navigation.navigate(
                                                    'add new address',
                                                    {
                                                        isUpdate: true,
                                                        item: address,
                                                        index,
                                                    }
                                                )
                                            }
                                        >
                                            <View style={AddressStyle.editIcon}>
                                                <CustomSVG svgIcon={EditIcon}
                                                    width={dpr(15)}
                                                    height={dpr(17)}
                                                />
                                            </View>
                                        </TouchableOpacity>
                                    )}
                                </View>
                                <View
                                    style={[
                                        AddressStyle.titleCont,
                                        gapStyle.mt19,
                                    ]}
                                >
                                    <Text
                                        style={[
                                            AddressStyle.name,
                                            AddressStyle.name2
                                        ]}
                                    >
                                        {`${first_name} ${
                                            last_name == null ? '' : last_name
                                        }`}
                                    </Text>
                                    <Text
                                        style={[
                                            AddressStyle.name,
                                            AddressStyle.phone
                                        ]}
                                    >
                                        {phone}
                                    </Text>
                                </View>
                                <Text
                                    style={AddressStyle.address}
                                >{`${address_1}. ${trans("City")}: ${city}. ${
                                    zip ? `${trans("Postcode")}: ${zip}.` : ''
                                } ${trans("Country")}: ${country_name || country}`}</Text>
                            </View>
                        </TouchableWithoutFeedback>
                    );
                })}
        </ScrollView>
    );
};

export default OrderAddresses;

const styles = StyleSheet.create({
    container: {
        maxHeight: dpr('hf') - dpr(260),
    },
    selectAddressText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginTop: dpr(16),
        marginBottom: dpr(20),
    },
});